/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsBlockDevice
implements ToCopyableBuilder<Builder, EbsBlockDevice> {
    private final Boolean encrypted;
    private final Boolean deleteOnTermination;
    private final Integer iops;
    private final String snapshotId;
    private final Integer volumeSize;
    private final String volumeType;

    private EbsBlockDevice(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Integer iops() {
        return this.iops;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public String volumeTypeString() {
        return this.volumeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        return Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.volumeTypeString(), other.volumeTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.volumeSize() != null) {
            sb.append("VolumeSize: ").append(this.volumeSize()).append(",");
        }
        if (this.volumeTypeString() != null) {
            sb.append("VolumeType: ").append(this.volumeTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "DeleteOnTermination": {
                return Optional.of(clazz.cast(this.deleteOnTermination()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "VolumeSize": {
                return Optional.of(clazz.cast(this.volumeSize()));
            }
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean encrypted;
        private Boolean deleteOnTermination;
        private Integer iops;
        private String snapshotId;
        private Integer volumeSize;
        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.encrypted(model.encrypted);
            this.deleteOnTermination(model.deleteOnTermination);
            this.iops(model.iops);
            this.snapshotId(model.snapshotId);
            this.volumeSize(model.volumeSize);
            this.volumeType(model.volumeType);
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder encrypted(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder iops(Integer var1);

        public Builder snapshotId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);
    }
}

