/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnection;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcPeeringConnectionsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
    private final List<VpcPeeringConnection> vpcPeeringConnections;

    private DescribeVpcPeeringConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnections = builder.vpcPeeringConnections;
    }

    public List<VpcPeeringConnection> vpcPeeringConnections() {
        return this.vpcPeeringConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsResponse)) {
            return false;
        }
        DescribeVpcPeeringConnectionsResponse other = (DescribeVpcPeeringConnectionsResponse)((Object)obj);
        return Objects.equals(this.vpcPeeringConnections(), other.vpcPeeringConnections());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vpcPeeringConnections() != null) {
            sb.append("VpcPeeringConnections: ").append(this.vpcPeeringConnections()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcPeeringConnections": {
                return Optional.of(clazz.cast(this.vpcPeeringConnections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<VpcPeeringConnection> vpcPeeringConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsResponse model) {
            this.vpcPeeringConnections(model.vpcPeeringConnections);
        }

        public final Collection<VpcPeeringConnection.Builder> getVpcPeeringConnections() {
            return this.vpcPeeringConnections != null ? (Collection)this.vpcPeeringConnections.stream().map(VpcPeeringConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(VpcPeeringConnection ... vpcPeeringConnections) {
            this.vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
            return this;
        }

        public final void setVpcPeeringConnections(Collection<VpcPeeringConnection.BuilderImpl> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copyFromBuilder(vpcPeeringConnections);
        }

        @Override
        public DescribeVpcPeeringConnectionsResponse build() {
            return new DescribeVpcPeeringConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
        public Builder vpcPeeringConnections(Collection<VpcPeeringConnection> var1);

        public Builder vpcPeeringConnections(VpcPeeringConnection ... var1);
    }
}

