/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.PlacementGroup;
import software.amazon.awssdk.services.ec2.model.PlacementGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePlacementGroupsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribePlacementGroupsResponse> {
    private final List<PlacementGroup> placementGroups;

    private DescribePlacementGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.placementGroups = builder.placementGroups;
    }

    public List<PlacementGroup> placementGroups() {
        return this.placementGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsResponse)) {
            return false;
        }
        DescribePlacementGroupsResponse other = (DescribePlacementGroupsResponse)((Object)obj);
        return Objects.equals(this.placementGroups(), other.placementGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.placementGroups() != null) {
            sb.append("PlacementGroups: ").append(this.placementGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementGroups": {
                return Optional.of(clazz.cast(this.placementGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<PlacementGroup> placementGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsResponse model) {
            this.placementGroups(model.placementGroups);
        }

        public final Collection<PlacementGroup.Builder> getPlacementGroups() {
            return this.placementGroups != null ? (Collection)this.placementGroups.stream().map(PlacementGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementGroups(Collection<PlacementGroup> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copy(placementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(PlacementGroup ... placementGroups) {
            this.placementGroups(Arrays.asList(placementGroups));
            return this;
        }

        public final void setPlacementGroups(Collection<PlacementGroup.BuilderImpl> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copyFromBuilder(placementGroups);
        }

        @Override
        public DescribePlacementGroupsResponse build() {
            return new DescribePlacementGroupsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribePlacementGroupsResponse> {
        public Builder placementGroups(Collection<PlacementGroup> var1);

        public Builder placementGroups(PlacementGroup ... var1);
    }
}

