/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.HostReservation;
import software.amazon.awssdk.services.ec2.model.HostReservationSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeHostReservationsResponse> {
    private final List<HostReservation> hostReservationSet;
    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    public List<HostReservation> hostReservationSet() {
        return this.hostReservationSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse)((Object)obj);
        return Objects.equals(this.hostReservationSet(), other.hostReservationSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostReservationSet() != null) {
            sb.append("HostReservationSet: ").append(this.hostReservationSet()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostReservationSet": {
                return Optional.of(clazz.cast(this.hostReservationSet()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<HostReservation> hostReservationSet;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            this.hostReservationSet(model.hostReservationSet);
            this.nextToken(model.nextToken);
        }

        public final Collection<HostReservation.Builder> getHostReservationSet() {
            return this.hostReservationSet != null ? (Collection)this.hostReservationSet.stream().map(HostReservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation ... hostReservationSet) {
            this.hostReservationSet(Arrays.asList(hostReservationSet));
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation.BuilderImpl> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copyFromBuilder(hostReservationSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        public Builder hostReservationSet(Collection<HostReservation> var1);

        public Builder hostReservationSet(HostReservation ... var1);

        public Builder nextToken(String var1);
    }
}

