/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ArchitectureValues {
    I386("i386"),
    X86_64("x86_64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ArchitectureValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArchitectureValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ArchitectureValues.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArchitectureValues> knownValues() {
        return Stream.of(ArchitectureValues.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

