/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;

public class ResetFpgaImageAttributeRequestMarshaller
implements Marshaller<Request<ResetFpgaImageAttributeRequest>, ResetFpgaImageAttributeRequest> {
    public Request<ResetFpgaImageAttributeRequest> marshall(ResetFpgaImageAttributeRequest resetFpgaImageAttributeRequest) {
        if (resetFpgaImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetFpgaImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ResetFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetFpgaImageAttributeRequest.fpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringUtils.fromString((String)resetFpgaImageAttributeRequest.fpgaImageId()));
        }
        if (resetFpgaImageAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)resetFpgaImageAttributeRequest.attributeString()));
        }
        return request;
    }
}

