/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;

public class ReplaceNetworkAclAssociationRequestMarshaller
implements Marshaller<Request<ReplaceNetworkAclAssociationRequest>, ReplaceNetworkAclAssociationRequest> {
    public Request<ReplaceNetworkAclAssociationRequest> marshall(ReplaceNetworkAclAssociationRequest replaceNetworkAclAssociationRequest) {
        if (replaceNetworkAclAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceNetworkAclAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceNetworkAclAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceNetworkAclAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceNetworkAclAssociationRequest.associationId()));
        }
        if (replaceNetworkAclAssociationRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)replaceNetworkAclAssociationRequest.networkAclId()));
        }
        return request;
    }
}

