/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;

public class ReplaceIamInstanceProfileAssociationRequestMarshaller
implements Marshaller<Request<ReplaceIamInstanceProfileAssociationRequest>, ReplaceIamInstanceProfileAssociationRequest> {
    public Request<ReplaceIamInstanceProfileAssociationRequest> marshall(ReplaceIamInstanceProfileAssociationRequest replaceIamInstanceProfileAssociationRequest) {
        if (replaceIamInstanceProfileAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceIamInstanceProfileAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceIamInstanceProfileAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        IamInstanceProfileSpecification iamInstanceProfile = replaceIamInstanceProfileAssociationRequest.iamInstanceProfile();
        if (iamInstanceProfile != null) {
            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
            }
            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
            }
        }
        if (replaceIamInstanceProfileAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceIamInstanceProfileAssociationRequest.associationId()));
        }
        return request;
    }
}

