/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.LoadPermissionModifications;
import software.amazon.awssdk.services.ec2.model.LoadPermissionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;

public class ModifyFpgaImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyFpgaImageAttributeRequest>, ModifyFpgaImageAttributeRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<ModifyFpgaImageAttributeRequest> marshall(ModifyFpgaImageAttributeRequest modifyFpgaImageAttributeRequest) {
        LoadPermissionModifications loadPermissionModifications;
        List<String> modifyFpgaImageAttributeRequestProductCodesList;
        List<String> modifyFpgaImageAttributeRequestUserGroupsList;
        List<String> modifyFpgaImageAttributeRequestUserIdsList;
        if (modifyFpgaImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyFpgaImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFpgaImageAttributeRequest.fpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.fpgaImageId()));
        }
        if (modifyFpgaImageAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.attributeString()));
        }
        if (modifyFpgaImageAttributeRequest.operationTypeString() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.operationTypeString()));
        }
        if ((modifyFpgaImageAttributeRequestUserIdsList = modifyFpgaImageAttributeRequest.userIds()) != null) {
            int userIdsListIndex = 1;
            for (String string : modifyFpgaImageAttributeRequestUserIdsList) {
                if (string != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)string));
                }
                ++userIdsListIndex;
            }
        }
        if ((modifyFpgaImageAttributeRequestUserGroupsList = modifyFpgaImageAttributeRequest.userGroups()) != null) {
            int userGroupsListIndex = 1;
            for (String string : modifyFpgaImageAttributeRequestUserGroupsList) {
                if (string != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)string));
                }
                ++userGroupsListIndex;
            }
        }
        if ((modifyFpgaImageAttributeRequestProductCodesList = modifyFpgaImageAttributeRequest.productCodes()) != null) {
            boolean bl = true;
            for (String modifyFpgaImageAttributeRequestProductCodesListValue : modifyFpgaImageAttributeRequestProductCodesList) {
                void var6_12;
                if (modifyFpgaImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + (int)var6_12, StringUtils.fromString((String)modifyFpgaImageAttributeRequestProductCodesListValue));
                }
                ++var6_12;
            }
        }
        if ((loadPermissionModifications = modifyFpgaImageAttributeRequest.loadPermission()) != null) {
            List<LoadPermissionRequest> loadPermissionModificationsRemoveList;
            List<LoadPermissionRequest> list = loadPermissionModifications.add();
            if (list != null) {
                int addListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsAddListValue : list) {
                    if (loadPermissionModificationsAddListValue.groupString() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)loadPermissionModificationsAddListValue.groupString()));
                    }
                    if (loadPermissionModificationsAddListValue.userId() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)loadPermissionModificationsAddListValue.userId()));
                    }
                    ++addListIndex;
                }
            }
            if ((loadPermissionModificationsRemoveList = loadPermissionModifications.remove()) != null) {
                int removeListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsRemoveListValue : loadPermissionModificationsRemoveList) {
                    if (loadPermissionModificationsRemoveListValue.groupString() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)loadPermissionModificationsRemoveListValue.groupString()));
                    }
                    if (loadPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)loadPermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyFpgaImageAttributeRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.description()));
        }
        if (modifyFpgaImageAttributeRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.name()));
        }
        return request;
    }
}

