/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointServicesRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServicesRequest>, DescribeVpcEndpointServicesRequest> {
    public Request<DescribeVpcEndpointServicesRequest> marshall(DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) {
        List<Filter> describeVpcEndpointServicesRequestFiltersList;
        if (describeVpcEndpointServicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcEndpointServicesRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcEndpointServices");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeVpcEndpointServicesRequestServiceNamesList = describeVpcEndpointServicesRequest.serviceNames();
        if (describeVpcEndpointServicesRequestServiceNamesList != null) {
            int serviceNamesListIndex = 1;
            for (String describeVpcEndpointServicesRequestServiceNamesListValue : describeVpcEndpointServicesRequestServiceNamesList) {
                if (describeVpcEndpointServicesRequestServiceNamesListValue != null) {
                    request.addParameter("ServiceName." + serviceNamesListIndex, StringUtils.fromString((String)describeVpcEndpointServicesRequestServiceNamesListValue));
                }
                ++serviceNamesListIndex;
            }
        }
        if ((describeVpcEndpointServicesRequestFiltersList = describeVpcEndpointServicesRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServicesRequestFiltersListValue : describeVpcEndpointServicesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointServicesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcEndpointServicesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVpcEndpointServicesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServicesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcEndpointServicesRequest.maxResults()));
        }
        if (describeVpcEndpointServicesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcEndpointServicesRequest.nextToken()));
        }
        return request;
    }
}

