/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;

public class DescribeVpcClassicLinkDnsSupportRequestMarshaller
implements Marshaller<Request<DescribeVpcClassicLinkDnsSupportRequest>, DescribeVpcClassicLinkDnsSupportRequest> {
    public Request<DescribeVpcClassicLinkDnsSupportRequest> marshall(DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest) {
        List<String> describeVpcClassicLinkDnsSupportRequestVpcIdsList;
        if (describeVpcClassicLinkDnsSupportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcClassicLinkDnsSupportRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcClassicLinkDnsSupport");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcClassicLinkDnsSupportRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcClassicLinkDnsSupportRequest.maxResults()));
        }
        if (describeVpcClassicLinkDnsSupportRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcClassicLinkDnsSupportRequest.nextToken()));
        }
        if ((describeVpcClassicLinkDnsSupportRequestVpcIdsList = describeVpcClassicLinkDnsSupportRequest.vpcIds()) != null) {
            int vpcIdsListIndex = 1;
            for (String describeVpcClassicLinkDnsSupportRequestVpcIdsListValue : describeVpcClassicLinkDnsSupportRequestVpcIdsList) {
                if (describeVpcClassicLinkDnsSupportRequestVpcIdsListValue != null) {
                    request.addParameter("VpcIds." + vpcIdsListIndex, StringUtils.fromString((String)describeVpcClassicLinkDnsSupportRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        return request;
    }
}

