/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        List<String> describeSecurityGroupsRequestGroupNamesList;
        List<String> describeSecurityGroupsRequestGroupIdsList;
        if (describeSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSecurityGroupsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeSecurityGroupsRequestFiltersList = describeSecurityGroupsRequest.filters();
        if (describeSecurityGroupsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter filter : describeSecurityGroupsRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filter.name()));
                }
                if ((filterValuesList = filter.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeSecurityGroupsRequestGroupIdsList = describeSecurityGroupsRequest.groupIds()) != null) {
            int groupIdsListIndex = 1;
            for (String describeSecurityGroupsRequestGroupIdsListValue : describeSecurityGroupsRequestGroupIdsList) {
                if (describeSecurityGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringUtils.fromString((String)describeSecurityGroupsRequestGroupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        if ((describeSecurityGroupsRequestGroupNamesList = describeSecurityGroupsRequest.groupNames()) != null) {
            boolean bl = true;
            for (String describeSecurityGroupsRequestGroupNamesListValue : describeSecurityGroupsRequestGroupNamesList) {
                void var6_12;
                if (describeSecurityGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + (int)var6_12, StringUtils.fromString((String)describeSecurityGroupsRequestGroupNamesListValue));
                }
                ++var6_12;
            }
        }
        if (describeSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSecurityGroupsRequest.nextToken()));
        }
        if (describeSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSecurityGroupsRequest.maxResults()));
        }
        return request;
    }
}

