/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {
    public Request<DescribeReservedInstancesOfferingsRequest> marshall(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        List<String> describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList;
        List<Filter> describeReservedInstancesOfferingsRequestFiltersList;
        if (describeReservedInstancesOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesOfferingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedInstancesOfferingsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.availabilityZone()));
        }
        if ((describeReservedInstancesOfferingsRequestFiltersList = describeReservedInstancesOfferingsRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesOfferingsRequestFiltersListValue : describeReservedInstancesOfferingsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesOfferingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeReservedInstancesOfferingsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeReservedInstancesOfferingsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.includeMarketplace() != null) {
            request.addParameter("IncludeMarketplace", StringUtils.fromBoolean((Boolean)describeReservedInstancesOfferingsRequest.includeMarketplace()));
        }
        if (describeReservedInstancesOfferingsRequest.instanceTypeString() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.instanceTypeString()));
        }
        if (describeReservedInstancesOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.maxDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.maxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxInstanceCount()));
        }
        if (describeReservedInstancesOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.minDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringClassString() != null) {
            request.addParameter("OfferingClass", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.offeringClassString()));
        }
        if (describeReservedInstancesOfferingsRequest.productDescriptionString() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.productDescriptionString()));
        }
        if ((describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList = describeReservedInstancesOfferingsRequest.reservedInstancesOfferingIds()) != null) {
            int reservedInstancesOfferingIdsListIndex = 1;
            for (String describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue : describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList) {
                if (describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue != null) {
                    request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringUtils.fromString((String)describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue));
                }
                ++reservedInstancesOfferingIdsListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.instanceTenancyString() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.instanceTenancyString()));
        }
        if (describeReservedInstancesOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxResults()));
        }
        if (describeReservedInstancesOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.nextToken()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringTypeString() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.offeringTypeString()));
        }
        return request;
    }
}

