/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkInterfacesRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacesRequest>, DescribeNetworkInterfacesRequest> {
    public Request<DescribeNetworkInterfacesRequest> marshall(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        List<String> describeNetworkInterfacesRequestNetworkInterfaceIdsList;
        if (describeNetworkInterfacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNetworkInterfacesRequest, "EC2Client");
        request.addParameter("Action", "DescribeNetworkInterfaces");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNetworkInterfacesRequestFiltersList = describeNetworkInterfacesRequest.filters();
        if (describeNetworkInterfacesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInterfacesRequestFiltersListValue : describeNetworkInterfacesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkInterfacesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeNetworkInterfacesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeNetworkInterfacesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeNetworkInterfacesRequestNetworkInterfaceIdsList = describeNetworkInterfacesRequest.networkInterfaceIds()) != null) {
            int networkInterfaceIdsListIndex = 1;
            for (String describeNetworkInterfacesRequestNetworkInterfaceIdsListValue : describeNetworkInterfacesRequestNetworkInterfaceIdsList) {
                if (describeNetworkInterfacesRequestNetworkInterfaceIdsListValue != null) {
                    request.addParameter("NetworkInterfaceId." + networkInterfaceIdsListIndex, StringUtils.fromString((String)describeNetworkInterfacesRequestNetworkInterfaceIdsListValue));
                }
                ++networkInterfaceIdsListIndex;
            }
        }
        return request;
    }
}

