/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;

public class DescribeConversionTasksRequestMarshaller
implements Marshaller<Request<DescribeConversionTasksRequest>, DescribeConversionTasksRequest> {
    public Request<DescribeConversionTasksRequest> marshall(DescribeConversionTasksRequest describeConversionTasksRequest) {
        if (describeConversionTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConversionTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeConversionTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeConversionTasksRequestConversionTaskIdsList = describeConversionTasksRequest.conversionTaskIds();
        if (describeConversionTasksRequestConversionTaskIdsList != null) {
            int conversionTaskIdsListIndex = 1;
            for (String describeConversionTasksRequestConversionTaskIdsListValue : describeConversionTasksRequestConversionTaskIdsList) {
                if (describeConversionTasksRequestConversionTaskIdsListValue != null) {
                    request.addParameter("ConversionTaskId." + conversionTaskIdsListIndex, StringUtils.fromString((String)describeConversionTasksRequestConversionTaskIdsListValue));
                }
                ++conversionTaskIdsListIndex;
            }
        }
        return request;
    }
}

