/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;

public class CreateSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateSecurityGroupRequest>, CreateSecurityGroupRequest> {
    public Request<CreateSecurityGroupRequest> marshall(CreateSecurityGroupRequest createSecurityGroupRequest) {
        if (createSecurityGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSecurityGroupRequest, "EC2Client");
        request.addParameter("Action", "CreateSecurityGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSecurityGroupRequest.description() != null) {
            request.addParameter("GroupDescription", StringUtils.fromString((String)createSecurityGroupRequest.description()));
        }
        if (createSecurityGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)createSecurityGroupRequest.groupName()));
        }
        if (createSecurityGroupRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createSecurityGroupRequest.vpcId()));
        }
        return request;
    }
}

