/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;

public class AttachVpnGatewayRequestMarshaller
implements Marshaller<Request<AttachVpnGatewayRequest>, AttachVpnGatewayRequest> {
    public Request<AttachVpnGatewayRequest> marshall(AttachVpnGatewayRequest attachVpnGatewayRequest) {
        if (attachVpnGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachVpnGatewayRequest, "EC2Client");
        request.addParameter("Action", "AttachVpnGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachVpnGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachVpnGatewayRequest.vpcId()));
        }
        if (attachVpnGatewayRequest.vpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString((String)attachVpnGatewayRequest.vpnGatewayId()));
        }
        return request;
    }
}

