/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;

public class AssignIpv6AddressesRequestMarshaller
implements Marshaller<Request<AssignIpv6AddressesRequest>, AssignIpv6AddressesRequest> {
    public Request<AssignIpv6AddressesRequest> marshall(AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        List<String> assignIpv6AddressesRequestIpv6AddressesList;
        if (assignIpv6AddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assignIpv6AddressesRequest, "EC2Client");
        request.addParameter("Action", "AssignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assignIpv6AddressesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)assignIpv6AddressesRequest.ipv6AddressCount()));
        }
        if ((assignIpv6AddressesRequestIpv6AddressesList = assignIpv6AddressesRequest.ipv6Addresses()) != null) {
            int ipv6AddressesListIndex = 1;
            for (String assignIpv6AddressesRequestIpv6AddressesListValue : assignIpv6AddressesRequestIpv6AddressesList) {
                if (assignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex, StringUtils.fromString((String)assignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (assignIpv6AddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)assignIpv6AddressesRequest.networkInterfaceId()));
        }
        return request;
    }
}

