/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.TargetConfigurationRequest;

public class AcceptReservedInstancesExchangeQuoteRequestMarshaller
implements Marshaller<Request<AcceptReservedInstancesExchangeQuoteRequest>, AcceptReservedInstancesExchangeQuoteRequest> {
    public Request<AcceptReservedInstancesExchangeQuoteRequest> marshall(AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) {
        List<TargetConfigurationRequest> acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList;
        if (acceptReservedInstancesExchangeQuoteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)acceptReservedInstancesExchangeQuoteRequest, "EC2Client");
        request.addParameter("Action", "AcceptReservedInstancesExchangeQuote");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList = acceptReservedInstancesExchangeQuoteRequest.reservedInstanceIds();
        if (acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList != null) {
            int reservedInstanceIdsListIndex = 1;
            for (String acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue : acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsList) {
                if (acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue != null) {
                    request.addParameter("ReservedInstanceId." + reservedInstanceIdsListIndex, StringUtils.fromString((String)acceptReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue));
                }
                ++reservedInstanceIdsListIndex;
            }
        }
        if ((acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList = acceptReservedInstancesExchangeQuoteRequest.targetConfigurations()) != null) {
            int targetConfigurationsListIndex = 1;
            for (TargetConfigurationRequest acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue : acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsList) {
                if (acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger((Integer)acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount()));
                }
                if (acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".OfferingId", StringUtils.fromString((String)acceptReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

