/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopInstancesRequest> {
    private final List<String> instanceIds;
    private final Boolean force;

    private StopInstancesRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.force = builder.force;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Boolean force() {
        return this.force;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesRequest)) {
            return false;
        }
        StopInstancesRequest other = (StopInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.force(), other.force());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
            case "Force": {
                return Optional.of(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesRequest model) {
            this.instanceIds(model.instanceIds);
            this.force(model.force);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public StopInstancesRequest build() {
            return new StopInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopInstancesRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder force(Boolean var1);
    }
}

