/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartInstancesRequest> {
    private final List<String> instanceIds;
    private final String additionalInfo;

    private StartInstancesRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.additionalInfo = builder.additionalInfo;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesRequest)) {
            return false;
        }
        StartInstancesRequest other = (StartInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.additionalInfo(), other.additionalInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
            case "AdditionalInfo": {
                return Optional.of(clazz.cast(this.additionalInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds;
        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesRequest model) {
            this.instanceIds(model.instanceIds);
            this.additionalInfo(model.additionalInfo);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public StartInstancesRequest build() {
            return new StartInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartInstancesRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder additionalInfo(String var1);
    }
}

