/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetInstanceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetInstanceAttributeRequest> {
    private final String attribute;
    private final String instanceId;

    private ResetInstanceAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.instanceId = builder.instanceId;
    }

    public InstanceAttributeName attribute() {
        return InstanceAttributeName.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetInstanceAttributeRequest)) {
            return false;
        }
        ResetInstanceAttributeRequest other = (ResetInstanceAttributeRequest)((Object)obj);
        return Objects.equals(this.attributeString(), other.attributeString()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetInstanceAttributeRequest model) {
            this.attribute(model.attribute);
            this.instanceId(model.instanceId);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public ResetInstanceAttributeRequest build() {
            return new ResetInstanceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetInstanceAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(InstanceAttributeName var1);

        public Builder instanceId(String var1);
    }
}

