/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifySubnetAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifySubnetAttributeRequest> {
    private final Boolean assignIpv6AddressOnCreation;
    private final Boolean mapPublicIpOnLaunch;
    private final String subnetId;

    private ModifySubnetAttributeRequest(BuilderImpl builder) {
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.subnetId = builder.subnetId;
    }

    public Boolean assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public Boolean mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySubnetAttributeRequest)) {
            return false;
        }
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest)((Object)obj);
        return Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.assignIpv6AddressOnCreation() != null) {
            sb.append("AssignIpv6AddressOnCreation: ").append(this.assignIpv6AddressOnCreation()).append(",");
        }
        if (this.mapPublicIpOnLaunch() != null) {
            sb.append("MapPublicIpOnLaunch: ").append(this.mapPublicIpOnLaunch()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignIpv6AddressOnCreation": {
                return Optional.of(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.of(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean assignIpv6AddressOnCreation;
        private Boolean mapPublicIpOnLaunch;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySubnetAttributeRequest model) {
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.subnetId(model.subnetId);
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public ModifySubnetAttributeRequest build() {
            return new ModifySubnetAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifySubnetAttributeRequest> {
        public Builder assignIpv6AddressOnCreation(Boolean var1);

        public Builder mapPublicIpOnLaunch(Boolean var1);

        public Builder subnetId(String var1);
    }
}

