/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyReservedInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyReservedInstancesRequest> {
    private final List<String> reservedInstancesIds;
    private final String clientToken;
    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<ReservedInstancesConfiguration> targetConfigurations() {
        return this.targetConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest)((Object)obj);
        return Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.targetConfigurations(), other.targetConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.reservedInstancesIds()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.targetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(this.targetConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesIds": {
                return Optional.of(clazz.cast(this.reservedInstancesIds()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "TargetConfigurations": {
                return Optional.of(clazz.cast(this.targetConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> reservedInstancesIds;
        private String clientToken;
        private List<ReservedInstancesConfiguration> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.clientToken(model.clientToken);
            this.targetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<ReservedInstancesConfiguration.Builder> getTargetConfigurations() {
            return this.targetConfigurations != null ? (Collection)this.targetConfigurations.stream().map(ReservedInstancesConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration.BuilderImpl> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copyFromBuilder(targetConfigurations);
        }

        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder targetConfigurations(Collection<ReservedInstancesConfiguration> var1);

        public Builder targetConfigurations(ReservedInstancesConfiguration ... var1);
    }
}

