/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportKeyPairRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportKeyPairRequest> {
    private final String keyName;
    private final String publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    public String keyName() {
        return this.keyName;
    }

    public String publicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyMaterial());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.publicKeyMaterial(), other.publicKeyMaterial());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.publicKeyMaterial() != null) {
            sb.append("PublicKeyMaterial: ").append(this.publicKeyMaterial()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
            case "PublicKeyMaterial": {
                return Optional.of(clazz.cast(this.publicKeyMaterial()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyName;
        private String publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            this.keyName(model.keyName);
            this.publicKeyMaterial(model.publicKeyMaterial);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getPublicKeyMaterial() {
            return this.publicKeyMaterial;
        }

        @Override
        public final Builder publicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        public final void setPublicKeyMaterial(String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
        }

        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportKeyPairRequest> {
        public Builder keyName(String var1);

        public Builder publicKeyMaterial(String var1);
    }
}

