/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.DiskImageDescription;
import software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceVolumeDetailItem
implements ToCopyableBuilder<Builder, ImportInstanceVolumeDetailItem> {
    private final String availabilityZone;
    private final Long bytesConverted;
    private final String description;
    private final DiskImageDescription image;
    private final String status;
    private final String statusMessage;
    private final DiskImageVolumeDescription volume;

    private ImportInstanceVolumeDetailItem(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.volume = builder.volume;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long bytesConverted() {
        return this.bytesConverted;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDescription image() {
        return this.image;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public DiskImageVolumeDescription volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesConverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceVolumeDetailItem)) {
            return false;
        }
        ImportInstanceVolumeDetailItem other = (ImportInstanceVolumeDetailItem)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.bytesConverted(), other.bytesConverted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.volume(), other.volume());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.bytesConverted() != null) {
            sb.append("BytesConverted: ").append(this.bytesConverted()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.volume() != null) {
            sb.append("Volume: ").append(this.volume()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "BytesConverted": {
                return Optional.of(clazz.cast(this.bytesConverted()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "Volume": {
                return Optional.of(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long bytesConverted;
        private String description;
        private DiskImageDescription image;
        private String status;
        private String statusMessage;
        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceVolumeDetailItem model) {
            this.availabilityZone(model.availabilityZone);
            this.bytesConverted(model.bytesConverted);
            this.description(model.description);
            this.image(model.image);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getBytesConverted() {
            return this.bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDescription.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        public ImportInstanceVolumeDetailItem build() {
            return new ImportInstanceVolumeDetailItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceVolumeDetailItem> {
        public Builder availabilityZone(String var1);

        public Builder bytesConverted(Long var1);

        public Builder description(String var1);

        public Builder image(DiskImageDescription var1);

        default public Builder image(Consumer<DiskImageDescription.Builder> image) {
            return this.image((DiskImageDescription)((DiskImageDescription.Builder)DiskImageDescription.builder().apply(image)).build());
        }

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder volume(DiskImageVolumeDescription var1);

        default public Builder volume(Consumer<DiskImageVolumeDescription.Builder> volume) {
            return this.volume((DiskImageVolumeDescription)((DiskImageVolumeDescription.Builder)DiskImageVolumeDescription.builder().apply(volume)).build());
        }
    }
}

