/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpnGatewayIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
    private final List<Filter> filters;
    private final List<String> vpnGatewayIds;

    private DescribeVpnGatewaysRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpnGatewayIds = builder.vpnGatewayIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> vpnGatewayIds() {
        return this.vpnGatewayIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysRequest)) {
            return false;
        }
        DescribeVpnGatewaysRequest other = (DescribeVpnGatewaysRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.vpnGatewayIds(), other.vpnGatewayIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.vpnGatewayIds() != null) {
            sb.append("VpnGatewayIds: ").append(this.vpnGatewayIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "VpnGatewayIds": {
                return Optional.of(clazz.cast(this.vpnGatewayIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> vpnGatewayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysRequest model) {
            this.filters(model.filters);
            this.vpnGatewayIds(model.vpnGatewayIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnGatewayIds() {
            return this.vpnGatewayIds;
        }

        @Override
        public final Builder vpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGatewayIds(String ... vpnGatewayIds) {
            this.vpnGatewayIds(Arrays.asList(vpnGatewayIds));
            return this;
        }

        public final void setVpnGatewayIds(Collection<String> vpnGatewayIds) {
            this.vpnGatewayIds = VpnGatewayIdStringListCopier.copy(vpnGatewayIds);
        }

        public DescribeVpnGatewaysRequest build() {
            return new DescribeVpnGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpnGatewaysRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder vpnGatewayIds(Collection<String> var1);

        public Builder vpnGatewayIds(String ... var1);
    }
}

