/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcPeeringConnectionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpcPeeringConnectionsRequest> {
    private final List<Filter> filters;
    private final List<String> vpcPeeringConnectionIds;

    private DescribeVpcPeeringConnectionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpcPeeringConnectionIds = builder.vpcPeeringConnectionIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> vpcPeeringConnectionIds() {
        return this.vpcPeeringConnectionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsRequest)) {
            return false;
        }
        DescribeVpcPeeringConnectionsRequest other = (DescribeVpcPeeringConnectionsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.vpcPeeringConnectionIds(), other.vpcPeeringConnectionIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.vpcPeeringConnectionIds() != null) {
            sb.append("VpcPeeringConnectionIds: ").append(this.vpcPeeringConnectionIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "VpcPeeringConnectionIds": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> vpcPeeringConnectionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsRequest model) {
            this.filters(model.filters);
            this.vpcPeeringConnectionIds(model.vpcPeeringConnectionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpcPeeringConnectionIds() {
            return this.vpcPeeringConnectionIds;
        }

        @Override
        public final Builder vpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
            this.vpcPeeringConnectionIds = ValueStringListCopier.copy(vpcPeeringConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnectionIds(String ... vpcPeeringConnectionIds) {
            this.vpcPeeringConnectionIds(Arrays.asList(vpcPeeringConnectionIds));
            return this;
        }

        public final void setVpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
            this.vpcPeeringConnectionIds = ValueStringListCopier.copy(vpcPeeringConnectionIds);
        }

        public DescribeVpcPeeringConnectionsRequest build() {
            return new DescribeVpcPeeringConnectionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcPeeringConnectionsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder vpcPeeringConnectionIds(Collection<String> var1);

        public Builder vpcPeeringConnectionIds(String ... var1);
    }
}

