/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotAttributeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
    private final List<CreateVolumePermission> createVolumePermissions;
    private final List<ProductCode> productCodes;
    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    public List<CreateVolumePermission> createVolumePermissions() {
        return this.createVolumePermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createVolumePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse)((Object)obj);
        return Objects.equals(this.createVolumePermissions(), other.createVolumePermissions()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.createVolumePermissions() != null) {
            sb.append("CreateVolumePermissions: ").append(this.createVolumePermissions()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateVolumePermissions": {
                return Optional.of(clazz.cast(this.createVolumePermissions()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<CreateVolumePermission> createVolumePermissions;
        private List<ProductCode> productCodes;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            this.createVolumePermissions(model.createVolumePermissions);
            this.productCodes(model.productCodes);
            this.snapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission.Builder> getCreateVolumePermissions() {
            return this.createVolumePermissions != null ? (Collection)this.createVolumePermissions.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission ... createVolumePermissions) {
            this.createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission.BuilderImpl> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copyFromBuilder(createVolumePermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        public Builder createVolumePermissions(Collection<CreateVolumePermission> var1);

        public Builder createVolumePermissions(CreateVolumePermission ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder snapshotId(String var1);
    }
}

