/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkInterfacePermissionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
    private final List<NetworkInterfacePermission> networkInterfacePermissions;
    private final String nextToken;

    private DescribeNetworkInterfacePermissionsResponse(BuilderImpl builder) {
        this.networkInterfacePermissions = builder.networkInterfacePermissions;
        this.nextToken = builder.nextToken;
    }

    public List<NetworkInterfacePermission> networkInterfacePermissions() {
        return this.networkInterfacePermissions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsResponse)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsResponse other = (DescribeNetworkInterfacePermissionsResponse)((Object)obj);
        return Objects.equals(this.networkInterfacePermissions(), other.networkInterfacePermissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.networkInterfacePermissions() != null) {
            sb.append("NetworkInterfacePermissions: ").append(this.networkInterfacePermissions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissions": {
                return Optional.of(clazz.cast(this.networkInterfacePermissions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<NetworkInterfacePermission> networkInterfacePermissions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsResponse model) {
            this.networkInterfacePermissions(model.networkInterfacePermissions);
            this.nextToken(model.nextToken);
        }

        public final Collection<NetworkInterfacePermission.Builder> getNetworkInterfacePermissions() {
            return this.networkInterfacePermissions != null ? (Collection)this.networkInterfacePermissions.stream().map(NetworkInterfacePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copy(networkInterfacePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(NetworkInterfacePermission ... networkInterfacePermissions) {
            this.networkInterfacePermissions(Arrays.asList(networkInterfacePermissions));
            return this;
        }

        public final void setNetworkInterfacePermissions(Collection<NetworkInterfacePermission.BuilderImpl> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copyFromBuilder(networkInterfacePermissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNetworkInterfacePermissionsResponse build() {
            return new DescribeNetworkInterfacePermissionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
        public Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> var1);

        public Builder networkInterfacePermissions(NetworkInterfacePermission ... var1);

        public Builder nextToken(String var1);
    }
}

