/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachment;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkInterfaceAttributeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNetworkInterfaceAttributeResponse> {
    private final NetworkInterfaceAttachment attachment;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final String networkInterfaceId;
    private final Boolean sourceDestCheck;

    private DescribeNetworkInterfaceAttributeResponse(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public NetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String description() {
        return this.description;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeResponse)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeResponse other = (DescribeNetworkInterfaceAttributeResponse)((Object)obj);
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attachment() != null) {
            sb.append("Attachment: ").append(this.attachment()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.of(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAttachment attachment;
        private String description;
        private List<GroupIdentifier> groups;
        private String networkInterfaceId;
        private Boolean sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeResponse model) {
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public DescribeNetworkInterfaceAttributeResponse build() {
            return new DescribeNetworkInterfaceAttributeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeResponse> {
        public Builder attachment(NetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((NetworkInterfaceAttachment)((NetworkInterfaceAttachment.Builder)NetworkInterfaceAttachment.builder().apply(attachment)).build());
        }

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(Boolean var1);
    }
}

