/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatusSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMovingAddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMovingAddressesResponse> {
    private final List<MovingAddressStatus> movingAddressStatuses;
    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<MovingAddressStatus> movingAddressStatuses() {
        return this.movingAddressStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.movingAddressStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse)((Object)obj);
        return Objects.equals(this.movingAddressStatuses(), other.movingAddressStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.movingAddressStatuses() != null) {
            sb.append("MovingAddressStatuses: ").append(this.movingAddressStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MovingAddressStatuses": {
                return Optional.of(clazz.cast(this.movingAddressStatuses()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            this.movingAddressStatuses(model.movingAddressStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus.Builder> getMovingAddressStatuses() {
            return this.movingAddressStatuses != null ? (Collection)this.movingAddressStatuses.stream().map(MovingAddressStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus ... movingAddressStatuses) {
            this.movingAddressStatuses(Arrays.asList(movingAddressStatuses));
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus.BuilderImpl> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copyFromBuilder(movingAddressStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        public Builder movingAddressStatuses(Collection<MovingAddressStatus> var1);

        public Builder movingAddressStatuses(MovingAddressStatus ... var1);

        public Builder nextToken(String var1);
    }
}

