/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.ReservationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancesResponse> {
    private final List<Reservation> reservations;
    private final String nextToken;

    private DescribeInstancesResponse(BuilderImpl builder) {
        this.reservations = builder.reservations;
        this.nextToken = builder.nextToken;
    }

    public List<Reservation> reservations() {
        return this.reservations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse)((Object)obj);
        return Objects.equals(this.reservations(), other.reservations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reservations() != null) {
            sb.append("Reservations: ").append(this.reservations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reservations": {
                return Optional.of(clazz.cast(this.reservations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Reservation> reservations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            this.reservations(model.reservations);
            this.nextToken(model.nextToken);
        }

        public final Collection<Reservation.Builder> getReservations() {
            return this.reservations != null ? (Collection)this.reservations.stream().map(Reservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ReservationListCopier.copy(reservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservations(Reservation ... reservations) {
            this.reservations(Arrays.asList(reservations));
            return this;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ReservationListCopier.copyFromBuilder(reservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancesResponse> {
        public Builder reservations(Collection<Reservation> var1);

        public Builder reservations(Reservation ... var1);

        public Builder nextToken(String var1);
    }
}

