/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ImageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private final List<Image> images;

    private DescribeImagesResponse(BuilderImpl builder) {
        this.images = builder.images;
    }

    public List<Image> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.images());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        return Objects.equals(this.images(), other.images());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.images() != null) {
            sb.append("Images: ").append(this.images()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Images": {
                return Optional.of(clazz.cast(this.images()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Image> images;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            this.images(model.images);
        }

        public final Collection<Image.Builder> getImages() {
            return this.images != null ? (Collection)this.images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);
    }
}

