/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.IdFormat;
import software.amazon.awssdk.services.ec2.model.IdFormatListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIdentityIdFormatResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeIdentityIdFormatResponse> {
    private final List<IdFormat> statuses;

    private DescribeIdentityIdFormatResponse(BuilderImpl builder) {
        this.statuses = builder.statuses;
    }

    public List<IdFormat> statuses() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatResponse)) {
            return false;
        }
        DescribeIdentityIdFormatResponse other = (DescribeIdentityIdFormatResponse)((Object)obj);
        return Objects.equals(this.statuses(), other.statuses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statuses() != null) {
            sb.append("Statuses: ").append(this.statuses()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statuses": {
                return Optional.of(clazz.cast(this.statuses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<IdFormat> statuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatResponse model) {
            this.statuses(model.statuses);
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            return this.statuses != null ? (Collection)this.statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        public DescribeIdentityIdFormatResponse build() {
            return new DescribeIdentityIdFormatResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIdentityIdFormatResponse> {
        public Builder statuses(Collection<IdFormat> var1);

        public Builder statuses(IdFormat ... var1);
    }
}

