/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ZoneNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAvailabilityZonesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
    private final List<Filter> filters;
    private final List<String> zoneNames;

    private DescribeAvailabilityZonesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.zoneNames = builder.zoneNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> zoneNames() {
        return this.zoneNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.zoneNames(), other.zoneNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.zoneNames() != null) {
            sb.append("ZoneNames: ").append(this.zoneNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ZoneNames": {
                return Optional.of(clazz.cast(this.zoneNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> zoneNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityZonesRequest model) {
            this.filters(model.filters);
            this.zoneNames(model.zoneNames);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getZoneNames() {
            return this.zoneNames;
        }

        @Override
        public final Builder zoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneNames(String ... zoneNames) {
            this.zoneNames(Arrays.asList(zoneNames));
            return this;
        }

        public final void setZoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
        }

        public DescribeAvailabilityZonesRequest build() {
            return new DescribeAvailabilityZonesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder zoneNames(Collection<String> var1);

        public Builder zoneNames(String ... var1);
    }
}

