/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateImageRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final String instanceId;
    private final String name;
    private final Boolean noReboot;

    private CreateImageRequest(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.noReboot = builder.noReboot;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String description() {
        return this.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String name() {
        return this.name;
    }

    public Boolean noReboot() {
        return this.noReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.noReboot());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest)((Object)obj);
        return Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.noReboot(), other.noReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.noReboot() != null) {
            sb.append("NoReboot: ").append(this.noReboot()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "NoReboot": {
                return Optional.of(clazz.cast(this.noReboot()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String description;
        private String instanceId;
        private String name;
        private Boolean noReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.description(model.description);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.noReboot(model.noReboot);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoReboot() {
            return this.noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateImageRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder noReboot(Boolean var1);
    }
}

