/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesListingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesListingsRequest>, DescribeReservedInstancesListingsRequest> {
    public Request<DescribeReservedInstancesListingsRequest> marshall(DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {
        if (describeReservedInstancesListingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesListingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesListings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeReservedInstancesListingsRequestFiltersList = describeReservedInstancesListingsRequest.filters();
        if (describeReservedInstancesListingsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesListingsRequestFiltersListValue : describeReservedInstancesListingsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesListingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeReservedInstancesListingsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeReservedInstancesListingsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesId()));
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesListingId() != null) {
            request.addParameter("ReservedInstancesListingId", StringUtils.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesListingId()));
        }
        return request;
    }
}

