/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeInternetGatewaysRequestMarshaller
implements Marshaller<Request<DescribeInternetGatewaysRequest>, DescribeInternetGatewaysRequest> {
    public Request<DescribeInternetGatewaysRequest> marshall(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        List<String> describeInternetGatewaysRequestInternetGatewayIdsList;
        if (describeInternetGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInternetGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeInternetGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeInternetGatewaysRequestFiltersList = describeInternetGatewaysRequest.filters();
        if (describeInternetGatewaysRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeInternetGatewaysRequestFiltersListValue : describeInternetGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeInternetGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInternetGatewaysRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeInternetGatewaysRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeInternetGatewaysRequestInternetGatewayIdsList = describeInternetGatewaysRequest.internetGatewayIds()) != null) {
            int internetGatewayIdsListIndex = 1;
            for (String describeInternetGatewaysRequestInternetGatewayIdsListValue : describeInternetGatewaysRequestInternetGatewayIdsList) {
                if (describeInternetGatewaysRequestInternetGatewayIdsListValue != null) {
                    request.addParameter("InternetGatewayId." + internetGatewayIdsListIndex, StringUtils.fromString((String)describeInternetGatewaysRequestInternetGatewayIdsListValue));
                }
                ++internetGatewayIdsListIndex;
            }
        }
        return request;
    }
}

