/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;

public class AssociateRouteTableRequestMarshaller
implements Marshaller<Request<AssociateRouteTableRequest>, AssociateRouteTableRequest> {
    public Request<AssociateRouteTableRequest> marshall(AssociateRouteTableRequest associateRouteTableRequest) {
        if (associateRouteTableRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateRouteTableRequest, "EC2Client");
        request.addParameter("Action", "AssociateRouteTable");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateRouteTableRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)associateRouteTableRequest.routeTableId()));
        }
        if (associateRouteTableRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)associateRouteTableRequest.subnetId()));
        }
        return request;
    }
}

