/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, TerminateInstancesResponse> {
    private final List<InstanceStateChange> terminatingInstances;

    private TerminateInstancesResponse(BuilderImpl builder) {
        this.terminatingInstances = builder.terminatingInstances;
    }

    public List<InstanceStateChange> terminatingInstances() {
        return this.terminatingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.terminatingInstances() == null ? 0 : this.terminatingInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstancesResponse)) {
            return false;
        }
        TerminateInstancesResponse other = (TerminateInstancesResponse)((Object)obj);
        if (other.terminatingInstances() == null ^ this.terminatingInstances() == null) {
            return false;
        }
        return other.terminatingInstances() == null || other.terminatingInstances().equals(this.terminatingInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.terminatingInstances() != null) {
            sb.append("TerminatingInstances: ").append(this.terminatingInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminatingInstances": {
                return Optional.of(clazz.cast(this.terminatingInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceStateChange> terminatingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstancesResponse model) {
            this.terminatingInstances(model.terminatingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getTerminatingInstances() {
            return this.terminatingInstances != null ? (Collection)this.terminatingInstances.stream().map(InstanceStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copy(terminatingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(InstanceStateChange ... terminatingInstances) {
            this.terminatingInstances(Arrays.asList(terminatingInstances));
            return this;
        }

        public final void setTerminatingInstances(Collection<InstanceStateChange.BuilderImpl> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copyFromBuilder(terminatingInstances);
        }

        public TerminateInstancesResponse build() {
            return new TerminateInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TerminateInstancesResponse> {
        public Builder terminatingInstances(Collection<InstanceStateChange> var1);

        public Builder terminatingInstances(InstanceStateChange ... var1);
    }
}

