/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Storage
implements ToCopyableBuilder<Builder, S3Storage> {
    private final String awsAccessKeyId;
    private final String bucket;
    private final String prefix;
    private final String uploadPolicy;
    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    public String awsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public String uploadPolicy() {
        return this.uploadPolicy;
    }

    public String uploadPolicySignature() {
        return this.uploadPolicySignature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.awsAccessKeyId() == null ? 0 : this.awsAccessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.uploadPolicy() == null ? 0 : this.uploadPolicy().hashCode());
        hashCode = 31 * hashCode + (this.uploadPolicySignature() == null ? 0 : this.uploadPolicySignature().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage)obj;
        if (other.awsAccessKeyId() == null ^ this.awsAccessKeyId() == null) {
            return false;
        }
        if (other.awsAccessKeyId() != null && !other.awsAccessKeyId().equals(this.awsAccessKeyId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.uploadPolicy() == null ^ this.uploadPolicy() == null) {
            return false;
        }
        if (other.uploadPolicy() != null && !other.uploadPolicy().equals(this.uploadPolicy())) {
            return false;
        }
        if (other.uploadPolicySignature() == null ^ this.uploadPolicySignature() == null) {
            return false;
        }
        return other.uploadPolicySignature() == null || other.uploadPolicySignature().equals(this.uploadPolicySignature());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.awsAccessKeyId() != null) {
            sb.append("AWSAccessKeyId: ").append(this.awsAccessKeyId()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.uploadPolicy() != null) {
            sb.append("UploadPolicy: ").append(this.uploadPolicy()).append(",");
        }
        if (this.uploadPolicySignature() != null) {
            sb.append("UploadPolicySignature: ").append(this.uploadPolicySignature()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccessKeyId": {
                return Optional.of(clazz.cast(this.awsAccessKeyId()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "UploadPolicy": {
                return Optional.of(clazz.cast(this.uploadPolicy()));
            }
            case "UploadPolicySignature": {
                return Optional.of(clazz.cast(this.uploadPolicySignature()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccessKeyId;
        private String bucket;
        private String prefix;
        private String uploadPolicy;
        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            this.awsAccessKeyId(model.awsAccessKeyId);
            this.bucket(model.bucket);
            this.prefix(model.prefix);
            this.uploadPolicy(model.uploadPolicy);
            this.uploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAWSAccessKeyId() {
            return this.awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final void setAWSAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadPolicy() {
            return this.uploadPolicy;
        }

        @Override
        public final Builder uploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
            return this;
        }

        public final void setUploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
        }

        public final String getUploadPolicySignature() {
            return this.uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        public S3Storage build() {
            return new S3Storage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Storage> {
        public Builder awsAccessKeyId(String var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder uploadPolicy(String var1);

        public Builder uploadPolicySignature(String var1);
    }
}

