/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyHostsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyHostsRequest> {
    private final String autoPlacement;
    private final List<String> hostIds;

    private ModifyHostsRequest(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.hostIds = builder.hostIds;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementString() {
        return this.autoPlacement;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoPlacementString() == null ? 0 : this.autoPlacementString().hashCode());
        hashCode = 31 * hashCode + (this.hostIds() == null ? 0 : this.hostIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)((Object)obj);
        if (other.autoPlacementString() == null ^ this.autoPlacementString() == null) {
            return false;
        }
        if (other.autoPlacementString() != null && !other.autoPlacementString().equals(this.autoPlacementString())) {
            return false;
        }
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        return other.hostIds() == null || other.hostIds().equals(this.hostIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoPlacementString() != null) {
            sb.append("AutoPlacement: ").append(this.autoPlacementString()).append(",");
        }
        if (this.hostIds() != null) {
            sb.append("HostIds: ").append(this.hostIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.of(clazz.cast(this.autoPlacementString()));
            }
            case "HostIds": {
                return Optional.of(clazz.cast(this.hostIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoPlacement;
        private List<String> hostIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsRequest model) {
            this.autoPlacement(model.autoPlacement);
            this.hostIds(model.hostIds);
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        public ModifyHostsRequest build() {
            return new ModifyHostsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyHostsRequest> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);
    }
}

