/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ReservationState;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostReservation
implements ToCopyableBuilder<Builder, HostReservation> {
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final Instant end;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String offeringId;
    private final String paymentOption;
    private final Instant start;
    private final String state;
    private final String upfrontPrice;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public Integer count() {
        return this.count;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public Instant end() {
        return this.end;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionString() {
        return this.paymentOption;
    }

    public Instant start() {
        return this.start;
    }

    public ReservationState state() {
        return ReservationState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.currencyCodeString() == null ? 0 : this.currencyCodeString().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        hashCode = 31 * hashCode + (this.hostIdSet() == null ? 0 : this.hostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.hostReservationId() == null ? 0 : this.hostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.hourlyPrice() == null ? 0 : this.hourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceFamily() == null ? 0 : this.instanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        hashCode = 31 * hashCode + (this.paymentOptionString() == null ? 0 : this.paymentOptionString().hashCode());
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.upfrontPrice() == null ? 0 : this.upfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation)obj;
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.hostReservationId() == null ^ this.hostReservationId() == null) {
            return false;
        }
        if (other.hostReservationId() != null && !other.hostReservationId().equals(this.hostReservationId())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        if (other.paymentOptionString() == null ^ this.paymentOptionString() == null) {
            return false;
        }
        if (other.paymentOptionString() != null && !other.paymentOptionString().equals(this.paymentOptionString())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        return other.upfrontPrice() == null || other.upfrontPrice().equals(this.upfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCodeString()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        if (this.hostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.hostIdSet()).append(",");
        }
        if (this.hostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.hostReservationId()).append(",");
        }
        if (this.hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.hourlyPrice()).append(",");
        }
        if (this.instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.instanceFamily()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        if (this.paymentOptionString() != null) {
            sb.append("PaymentOption: ").append(this.paymentOptionString()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.upfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "End": {
                return Optional.of(clazz.cast(this.end()));
            }
            case "HostIdSet": {
                return Optional.of(clazz.cast(this.hostIdSet()));
            }
            case "HostReservationId": {
                return Optional.of(clazz.cast(this.hostReservationId()));
            }
            case "HourlyPrice": {
                return Optional.of(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceFamily": {
                return Optional.of(clazz.cast(this.instanceFamily()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
            case "PaymentOption": {
                return Optional.of(clazz.cast(this.paymentOptionString()));
            }
            case "Start": {
                return Optional.of(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "UpfrontPrice": {
                return Optional.of(clazz.cast(this.upfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private Instant end;
        private List<String> hostIdSet;
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String offeringId;
        private String paymentOption;
        private Instant start;
        private String state;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            this.count(model.count);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.end(model.end);
            this.hostIdSet(model.hostIdSet);
            this.hostReservationId(model.hostReservationId);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceFamily(model.instanceFamily);
            this.offeringId(model.offeringId);
            this.paymentOption(model.paymentOption);
            this.start(model.start);
            this.state(model.state);
            this.upfrontPrice(model.upfrontPrice);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public HostReservation build() {
            return new HostReservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostReservation> {
        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder end(Instant var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder start(Instant var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder upfrontPrice(String var1);
    }
}

