/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcEndpointsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
    private final String nextToken;
    private final List<VpcEndpoint> vpcEndpoints;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.vpcEndpoints = builder.vpcEndpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.vpcEndpoints() == null ? 0 : this.vpcEndpoints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcEndpoints() == null ^ this.vpcEndpoints() == null) {
            return false;
        }
        return other.vpcEndpoints() == null || other.vpcEndpoints().equals(this.vpcEndpoints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpcEndpoints() != null) {
            sb.append("VpcEndpoints: ").append(this.vpcEndpoints()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "VpcEndpoints": {
                return Optional.of(clazz.cast(this.vpcEndpoints()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VpcEndpoint> vpcEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            this.nextToken(model.nextToken);
            this.vpcEndpoints(model.vpcEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VpcEndpoint.Builder> getVpcEndpoints() {
            return this.vpcEndpoints != null ? (Collection)this.vpcEndpoints.stream().map(VpcEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            this.vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copyFromBuilder(vpcEndpoints);
        }

        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder vpcEndpoints(Collection<VpcEndpoint> var1);

        public Builder vpcEndpoints(VpcEndpoint ... var1);
    }
}

