/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.AccountAttribute;
import software.amazon.awssdk.services.ec2.model.AccountAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        this.accountAttributes = builder.accountAttributes;
    }

    public List<AccountAttribute> accountAttributes() {
        return this.accountAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountAttributes() == null ? 0 : this.accountAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        if (other.accountAttributes() == null ^ this.accountAttributes() == null) {
            return false;
        }
        return other.accountAttributes() == null || other.accountAttributes().equals(this.accountAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountAttributes() != null) {
            sb.append("AccountAttributes: ").append(this.accountAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAttributes": {
                return Optional.of(clazz.cast(this.accountAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AccountAttribute> accountAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            this.accountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute.Builder> getAccountAttributes() {
            return this.accountAttributes != null ? (Collection)this.accountAttributes.stream().map(AccountAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute ... accountAttributes) {
            this.accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute.BuilderImpl> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copyFromBuilder(accountAttributes);
        }

        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountAttributes(Collection<AccountAttribute> var1);

        public Builder accountAttributes(AccountAttribute ... var1);
    }
}

