/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class UnmonitorInstancesRequestMarshaller
implements Marshaller<Request<UnmonitorInstancesRequest>, UnmonitorInstancesRequest> {
    public Request<UnmonitorInstancesRequest> marshall(UnmonitorInstancesRequest unmonitorInstancesRequest) {
        if (unmonitorInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unmonitorInstancesRequest, "EC2Client");
        request.addParameter("Action", "UnmonitorInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> unmonitorInstancesRequestInstanceIdsList = unmonitorInstancesRequest.instanceIds();
        if (unmonitorInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String unmonitorInstancesRequestInstanceIdsListValue : unmonitorInstancesRequestInstanceIdsList) {
                if (unmonitorInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)unmonitorInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

