/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ClientData;

public class ClientDataUnmarshaller
implements Unmarshaller<ClientData, StaxUnmarshallerContext> {
    private static final ClientDataUnmarshaller INSTANCE = new ClientDataUnmarshaller();

    public ClientData unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ClientData.Builder clientData = ClientData.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    clientData.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UploadEnd", targetDepth)) {
                    clientData.uploadEnd(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UploadSize", targetDepth)) {
                    clientData.uploadSize(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UploadStart", targetDepth)) continue;
                clientData.uploadStart(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ClientData)clientData.build();
    }

    public static ClientDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

