/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcPeeringConnectionOptionsDescription
implements ToCopyableBuilder<Builder, VpcPeeringConnectionOptionsDescription> {
    private final Boolean allowDnsResolutionFromRemoteVpc;
    private final Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
    private final Boolean allowEgressFromLocalVpcToRemoteClassicLink;

    private VpcPeeringConnectionOptionsDescription(BuilderImpl builder) {
        this.allowDnsResolutionFromRemoteVpc = builder.allowDnsResolutionFromRemoteVpc;
        this.allowEgressFromLocalClassicLinkToRemoteVpc = builder.allowEgressFromLocalClassicLinkToRemoteVpc;
        this.allowEgressFromLocalVpcToRemoteClassicLink = builder.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public Boolean allowDnsResolutionFromRemoteVpc() {
        return this.allowDnsResolutionFromRemoteVpc;
    }

    public Boolean allowEgressFromLocalClassicLinkToRemoteVpc() {
        return this.allowEgressFromLocalClassicLinkToRemoteVpc;
    }

    public Boolean allowEgressFromLocalVpcToRemoteClassicLink() {
        return this.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allowDnsResolutionFromRemoteVpc() == null ? 0 : this.allowDnsResolutionFromRemoteVpc().hashCode());
        hashCode = 31 * hashCode + (this.allowEgressFromLocalClassicLinkToRemoteVpc() == null ? 0 : this.allowEgressFromLocalClassicLinkToRemoteVpc().hashCode());
        hashCode = 31 * hashCode + (this.allowEgressFromLocalVpcToRemoteClassicLink() == null ? 0 : this.allowEgressFromLocalVpcToRemoteClassicLink().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionOptionsDescription)) {
            return false;
        }
        VpcPeeringConnectionOptionsDescription other = (VpcPeeringConnectionOptionsDescription)obj;
        if (other.allowDnsResolutionFromRemoteVpc() == null ^ this.allowDnsResolutionFromRemoteVpc() == null) {
            return false;
        }
        if (other.allowDnsResolutionFromRemoteVpc() != null && !other.allowDnsResolutionFromRemoteVpc().equals(this.allowDnsResolutionFromRemoteVpc())) {
            return false;
        }
        if (other.allowEgressFromLocalClassicLinkToRemoteVpc() == null ^ this.allowEgressFromLocalClassicLinkToRemoteVpc() == null) {
            return false;
        }
        if (other.allowEgressFromLocalClassicLinkToRemoteVpc() != null && !other.allowEgressFromLocalClassicLinkToRemoteVpc().equals(this.allowEgressFromLocalClassicLinkToRemoteVpc())) {
            return false;
        }
        if (other.allowEgressFromLocalVpcToRemoteClassicLink() == null ^ this.allowEgressFromLocalVpcToRemoteClassicLink() == null) {
            return false;
        }
        return other.allowEgressFromLocalVpcToRemoteClassicLink() == null || other.allowEgressFromLocalVpcToRemoteClassicLink().equals(this.allowEgressFromLocalVpcToRemoteClassicLink());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowDnsResolutionFromRemoteVpc() != null) {
            sb.append("AllowDnsResolutionFromRemoteVpc: ").append(this.allowDnsResolutionFromRemoteVpc()).append(",");
        }
        if (this.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
            sb.append("AllowEgressFromLocalClassicLinkToRemoteVpc: ").append(this.allowEgressFromLocalClassicLinkToRemoteVpc()).append(",");
        }
        if (this.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
            sb.append("AllowEgressFromLocalVpcToRemoteClassicLink: ").append(this.allowEgressFromLocalVpcToRemoteClassicLink()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean allowDnsResolutionFromRemoteVpc;
        private Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
        private Boolean allowEgressFromLocalVpcToRemoteClassicLink;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionOptionsDescription model) {
            this.setAllowDnsResolutionFromRemoteVpc(model.allowDnsResolutionFromRemoteVpc);
            this.setAllowEgressFromLocalClassicLinkToRemoteVpc(model.allowEgressFromLocalClassicLinkToRemoteVpc);
            this.setAllowEgressFromLocalVpcToRemoteClassicLink(model.allowEgressFromLocalVpcToRemoteClassicLink);
        }

        public final Boolean getAllowDnsResolutionFromRemoteVpc() {
            return this.allowDnsResolutionFromRemoteVpc;
        }

        @Override
        public final Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
            return this;
        }

        public final void setAllowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalClassicLinkToRemoteVpc() {
            return this.allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        @Override
        public final Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
            return this;
        }

        public final void setAllowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalVpcToRemoteClassicLink() {
            return this.allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public final Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
            return this;
        }

        public final void setAllowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
        }

        public VpcPeeringConnectionOptionsDescription build() {
            return new VpcPeeringConnectionOptionsDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringConnectionOptionsDescription> {
        public Builder allowDnsResolutionFromRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean var1);
    }
}

