/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnassignIpv6AddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
    private final String networkInterfaceId;
    private final List<String> unassignedIpv6Addresses;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> unassignedIpv6Addresses() {
        return this.unassignedIpv6Addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.unassignedIpv6Addresses() == null ? 0 : this.unassignedIpv6Addresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse)((Object)obj);
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.unassignedIpv6Addresses() == null ^ this.unassignedIpv6Addresses() == null) {
            return false;
        }
        return other.unassignedIpv6Addresses() == null || other.unassignedIpv6Addresses().equals(this.unassignedIpv6Addresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.unassignedIpv6Addresses() != null) {
            sb.append("UnassignedIpv6Addresses: ").append(this.unassignedIpv6Addresses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<String> unassignedIpv6Addresses;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setUnassignedIpv6Addresses(model.unassignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            return this.unassignedIpv6Addresses;
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String ... unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        public Builder networkInterfaceId(String var1);

        public Builder unassignedIpv6Addresses(Collection<String> var1);

        public Builder unassignedIpv6Addresses(String ... var1);
    }
}

